"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CryptoService = void 0;
var _nodeCrypto = require("node:crypto");
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CryptoService {
  getHash(payload) {
    const hash = (0, _nodeCrypto.createHash)('sha256');
    hash.update(payload);
    return hash.digest('hex');
  }
  stringifyDeterministically(obj) {
    if (obj == null) {
      return null;
    }
    return (0, _jsonStableStringify.default)(obj);
  }
}
exports.CryptoService = CryptoService;