"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommentsSynchronizationSourceQuery = exports.CAI_COMMENTS_SYNCHRONIZATION_TASK_ID = exports.CAI_COMMENTS_SOURCE_QUERY = exports.CAI_COMMENTS_SOURCE_INDEX = exports.CAI_COMMENTS_INDEX_VERSION = exports.CAI_COMMENTS_INDEX_NAME = exports.CAI_COMMENTS_INDEX_ALIAS = exports.CAI_COMMENTS_BACKFILL_TASK_ID = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_COMMENTS_INDEX_NAME = exports.CAI_COMMENTS_INDEX_NAME = '.internal.cases-comments';
const CAI_COMMENTS_INDEX_ALIAS = exports.CAI_COMMENTS_INDEX_ALIAS = '.cases-comments';
const CAI_COMMENTS_INDEX_VERSION = exports.CAI_COMMENTS_INDEX_VERSION = 1;
const CAI_COMMENTS_SOURCE_QUERY = exports.CAI_COMMENTS_SOURCE_QUERY = {
  bool: {
    filter: [{
      term: {
        type: 'cases-comments'
      }
    }, {
      term: {
        'cases-comments.type': 'user'
      }
    }]
  }
};
const CAI_COMMENTS_SOURCE_INDEX = exports.CAI_COMMENTS_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_COMMENTS_BACKFILL_TASK_ID = exports.CAI_COMMENTS_BACKFILL_TASK_ID = 'cai_comments_backfill_task';
const CAI_COMMENTS_SYNCHRONIZATION_TASK_ID = exports.CAI_COMMENTS_SYNCHRONIZATION_TASK_ID = 'cai_cases_comments_synchronization_task';
const getCommentsSynchronizationSourceQuery = lastSyncAt => ({
  bool: {
    must: [{
      term: {
        'cases-comments.type': 'user'
      }
    }, {
      term: {
        type: 'cases-comments'
      }
    }, {
      bool: {
        should: [{
          range: {
            'cases-comments.created_at': {
              gte: lastSyncAt.toISOString()
            }
          }
        }, {
          range: {
            'cases-comments.updated_at': {
              gte: lastSyncAt.toISOString()
            }
          }
        }]
      }
    }]
  }
});
exports.getCommentsSynchronizationSourceQuery = getCommentsSynchronizationSourceQuery;