"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeUnitOptions = exports.getTimeUnitLabels = void 0;
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimeUnitOptions = unitSize => {
  return Object.entries(_constants.TIME_UNITS).map(([_key, value]) => {
    return {
      text: getTimeUnitLabels(value, unitSize === '' ? '0' : unitSize),
      value
    };
  });
};
exports.getTimeUnitOptions = getTimeUnitOptions;
const getTimeUnitLabels = (timeUnit = _constants.TIME_UNITS.DAYS, timeValue = '0') => {
  switch (timeUnit) {
    case _constants.TIME_UNITS.DAYS:
      return i18n.DAYS(timeValue);
    case _constants.TIME_UNITS.WEEKS:
      return i18n.WEEKS(timeValue);
    case _constants.TIME_UNITS.HOURS:
      return i18n.HOURS(timeValue);
    case _constants.TIME_UNITS.MINUTES:
      return i18n.MINUTES(timeValue);
  }
};
exports.getTimeUnitLabels = getTimeUnitLabels;