"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensOpenVisualization = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _types = require("../../../../client/attachment_framework/types");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../../../../common/utils/markdown_plugins/utils");
var _translations = require("../../../visualizations/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensOpenVisualization = ({
  comment
}) => {
  var _parsedComment$childr, _lensVisualization$;
  const parsedComment = (0, _utils.parseCommentString)(comment);
  const lensVisualization = (0, _utils.getLensVisualizations)((_parsedComment$childr = parsedComment === null || parsedComment === void 0 ? void 0 : parsedComment.children) !== null && _parsedComment$childr !== void 0 ? _parsedComment$childr : []);
  const {
    lens: {
      navigateToPrefilledEditor,
      canUseEditor
    }
  } = (0, _kibana.useKibana)().services;
  const hasLensPermissions = canUseEditor();
  const handleClick = (0, _react.useCallback)(() => {
    navigateToPrefilledEditor({
      id: '',
      timeRange: lensVisualization[0].timeRange,
      attributes: lensVisualization[0].attributes
    }, {
      openInNewTab: true
    });
  }, [lensVisualization, navigateToPrefilledEditor]);
  if (!lensVisualization.length || (lensVisualization === null || lensVisualization === void 0 ? void 0 : (_lensVisualization$ = lensVisualization[0]) === null || _lensVisualization$ === void 0 ? void 0 : _lensVisualization$.attributes) == null) {
    return {
      canUseEditor: hasLensPermissions,
      actionConfig: null
    };
  }
  const lensAttributes = lensVisualization[0].attributes;
  const isESQLQuery = (0, _esQuery.isOfAggregateQueryType)(lensAttributes.state.query);
  if (isESQLQuery) {
    return {
      canUseEditor: hasLensPermissions,
      actionConfig: null
    };
  }
  return {
    canUseEditor: hasLensPermissions,
    actionConfig: {
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'lensApp',
      label: _translations.OPEN_IN_VISUALIZATION,
      onClick: handleClick
    }
  };
};
exports.useLensOpenVisualization = useLensOpenVisualization;