"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleExperimentalBadge = exports.TitleBetaBadge = exports.Title = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _truncated_text = require("../truncated_text");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExperimentalBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: i18n.EXPERIMENTAL_LABEL,
  tooltipContent: i18n.EXPERIMENTAL_DESC,
  tooltipPosition: "bottom"
});
ExperimentalBadge.displayName = 'ExperimentalBadge';
const TitleExperimentalBadge = exports.TitleExperimentalBadge = /*#__PURE__*/_react.default.memo(ExperimentalBadge);
const BetaBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  label: i18n.BETA_LABEL,
  tooltipContent: i18n.BETA_DESC,
  tooltipPosition: "bottom"
});
BetaBadge.displayName = 'BetaBadge';
const TitleBetaBadge = exports.TitleBetaBadge = /*#__PURE__*/_react.default.memo(BetaBadge);
const TitleComponent = ({
  title,
  releasePhase,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "baseline",
  gutterSize: "s",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l"
}, /*#__PURE__*/_react.default.createElement("h1", {
  "data-test-subj": "header-page-title"
}, (0, _lodash.isString)(title) ? /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
  text: title
}) : title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, children))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, releasePhase === 'experimental' && /*#__PURE__*/_react.default.createElement(ExperimentalBadge, null), releasePhase === 'beta' && /*#__PURE__*/_react.default.createElement(BetaBadge, null)));
TitleComponent.displayName = 'Title';
const Title = exports.Title = /*#__PURE__*/_react.default.memo(TitleComponent);