"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterPopoverComponent = exports.FilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toggleSelectedGroup = (group, selectedGroups) => {
  const selectedGroupIndex = selectedGroups.indexOf(group);
  if (selectedGroupIndex >= 0) {
    return [...selectedGroups.slice(0, selectedGroupIndex), ...selectedGroups.slice(selectedGroupIndex + 1)];
  }
  return [...selectedGroups, group];
};

/**
 * Popover for selecting a field to filter on
 *
 * @param buttonLabel label on dropdwon button
 * @param onSelectedOptionsChanged change listener to be notified when option selection changes
 * @param options to display for filtering
 * @param optionsEmptyLabel shows when options empty
 * @param selectedOptions manage state of selectedOptions
 */
const FilterPopoverComponent = ({
  buttonLabel,
  onSelectedOptionsChanged,
  options,
  optionsEmptyLabel,
  selectedOptions,
  limit,
  limitReachedMessage
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const setIsPopoverOpenCb = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const toggleSelectedGroupCb = (0, _react.useCallback)(option => onSelectedOptionsChanged(toggleSelectedGroup(option, selectedOptions)), [selectedOptions, onSelectedOptionsChanged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": `options-filter-popover-button-${buttonLabel}`,
      iconType: "arrowDown",
      onClick: setIsPopoverOpenCb,
      isSelected: isPopoverOpen,
      numFilters: options.length,
      hasActiveFilters: selectedOptions.length > 0,
      numActiveFilters: selectedOptions.length,
      "aria-label": buttonLabel
    }, buttonLabel),
    isOpen: isPopoverOpen,
    closePopover: setIsPopoverOpenCb,
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, limit && limitReachedMessage && selectedOptions.length >= limit ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: limitReachedMessage,
    color: "warning",
    size: "s",
    "data-test-subj": "maximum-length-warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })) : null, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          max-height: 250px;
          overflow: auto;
        `
  }, options.map((option, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedOptions.includes(option) ? 'on' : undefined,
    disabled: Boolean(limit && selectedOptions.length >= limit && !selectedOptions.includes(option)),
    "data-test-subj": `options-filter-popover-item-${option}`,
    key: `${index}-${option}`,
    onClick: toggleSelectedGroupCb.bind(null, option)
  }, option))), options.length === 0 && optionsEmptyLabel != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, optionsEmptyLabel)))));
};
exports.FilterPopoverComponent = FilterPopoverComponent;
FilterPopoverComponent.displayName = 'FilterPopoverComponent';
const FilterPopover = exports.FilterPopover = /*#__PURE__*/_react.default.memo(FilterPopoverComponent);
FilterPopover.displayName = 'FilterPopover';