"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCancelCreationAction = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCancelCreationAction = ({
  onConfirmationCallback
}) => {
  const [showConfirmationModal, setShowConfirmationModal] = (0, _react.useState)(false);
  const onOpenModal = (0, _react.useCallback)(() => {
    setShowConfirmationModal(true);
  }, []);
  const onConfirmModal = (0, _react.useCallback)(() => {
    setShowConfirmationModal(false);
    onConfirmationCallback();
  }, [onConfirmationCallback]);
  const onCancelModal = (0, _react.useCallback)(() => {
    setShowConfirmationModal(false);
  }, []);
  return {
    showConfirmationModal,
    onOpenModal,
    onConfirmModal,
    onCancelModal
  };
};
exports.useCancelCreationAction = useCancelCreationAction;