"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CREATE_COMMENT_WARNING_TITLE = exports.CREATE_COMMENT_WARNING_DESC = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_COMMENT_WARNING_TITLE = exports.CREATE_COMMENT_WARNING_TITLE = _i18n.i18n.translate('xpack.cases.connectors.card.createCommentWarningTitle', {
  defaultMessage: 'Unable to share case comments'
});
const CREATE_COMMENT_WARNING_DESC = connectorName => _i18n.i18n.translate('xpack.cases.connectors.card.createCommentWarningDesc', {
  values: {
    connectorName
  },
  defaultMessage: 'Configure the Create Comment URL and Create Comment Objects fields for the {connectorName} connector to share comments externally.'
});
exports.CREATE_COMMENT_WARNING_DESC = CREATE_COMMENT_WARNING_DESC;