"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringToIntegerWithDefault = exports.stringToInteger = exports.isFlattenCustomField = exports.flattenCustomFieldKey = exports.deflattenCustomFieldKey = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isFlattenCustomField = key => key.startsWith(_constants.CUSTOM_FIELD_KEY_PREFIX);
exports.isFlattenCustomField = isFlattenCustomField;
const flattenCustomFieldKey = key => `${_constants.CUSTOM_FIELD_KEY_PREFIX}${key}`;
exports.flattenCustomFieldKey = flattenCustomFieldKey;
const deflattenCustomFieldKey = key => key.replace(_constants.CUSTOM_FIELD_KEY_PREFIX, '');
exports.deflattenCustomFieldKey = deflattenCustomFieldKey;
const stringToInteger = value => {
  const num = Number(value);
  if (isNaN(num)) {
    return;
  }
  return num;
};
exports.stringToInteger = stringToInteger;
const stringToIntegerWithDefault = (value, defaultValue) => {
  const valueAsInteger = stringToInteger(value);
  return valueAsInteger && valueAsInteger > 0 ? valueAsInteger : defaultValue;
};
exports.stringToIntegerWithDefault = stringToIntegerWithDefault;