"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesColumnsSelection = useCasesColumnsSelection;
var _constants = require("../../../common/constants");
var _use_cases_columns_configuration = require("./use_cases_columns_configuration");
var _merge_selected_columns_with_configuration = require("./utils/merge_selected_columns_with_configuration");
var _use_cases_local_storage = require("../../common/use_cases_local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCasesColumnsSelection() {
  const casesColumnsConfig = (0, _use_cases_columns_configuration.useCasesColumnsConfiguration)();
  const [selectedColumns, setSelectedColumns] = (0, _use_cases_local_storage.useCasesLocalStorage)(_constants.LOCAL_STORAGE_KEYS.casesTableColumns, []);
  const columns = selectedColumns || [];
  return {
    selectedColumns: (0, _merge_selected_columns_with_configuration.mergeSelectedColumnsWithConfiguration)({
      selectedColumns: columns,
      casesColumnsConfig
    }),
    setSelectedColumns
  };
}