"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStatusAction = void 0;
var _react = require("react");
var _use_bulk_update_case = require("../../../containers/use_bulk_update_case");
var _domain = require("../../../../common/types/domain");
var i18n = _interopRequireWildcard(require("./translations"));
var _status = require("../../status");
var _use_user_permissions = require("../../user_actions/use_user_permissions");
var _use_should_disable_status = require("./use_should_disable_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStatusToasterMessage = (status, cases) => {
  const totalCases = cases.length;
  const caseTitle = totalCases === 1 ? cases[0].title : '';
  if (status === _domain.CaseStatuses.open) {
    return i18n.REOPENED_CASES({
      totalCases,
      caseTitle
    });
  } else if (status === _domain.CaseStatuses['in-progress']) {
    return i18n.MARK_IN_PROGRESS_CASES({
      totalCases,
      caseTitle
    });
  } else if (status === _domain.CaseStatuses.closed) {
    return i18n.CLOSED_CASES({
      totalCases,
      caseTitle
    });
  }
  return '';
};
const useStatusAction = ({
  onAction,
  onActionSuccess,
  isDisabled,
  selectedStatus
}) => {
  const {
    mutate: updateCases
  } = (0, _use_bulk_update_case.useUpdateCases)();
  const {
    canUpdate,
    canReopenCase
  } = (0, _use_user_permissions.useUserPermissions)();
  const handleUpdateCaseStatus = (0, _react.useCallback)((selectedCases, status) => {
    onAction();
    const casesToUpdate = selectedCases.map(theCase => ({
      status,
      id: theCase.id,
      version: theCase.version
    }));
    updateCases({
      cases: casesToUpdate,
      successToasterTitle: getStatusToasterMessage(status, selectedCases)
    }, {
      onSuccess: onActionSuccess
    });
  }, [onAction, updateCases, onActionSuccess]);
  const shouldDisableStatus = (0, _use_should_disable_status.useShouldDisableStatus)();
  const getStatusIcon = status => selectedStatus && selectedStatus === status ? 'check' : 'empty';
  const getActions = selectedCases => {
    return [{
      name: _status.statuses[_domain.CaseStatuses.open].label,
      icon: getStatusIcon(_domain.CaseStatuses.open),
      onClick: () => handleUpdateCaseStatus(selectedCases, _domain.CaseStatuses.open),
      disabled: isDisabled || shouldDisableStatus(selectedCases),
      'data-test-subj': 'cases-bulk-action-status-open',
      key: 'cases-bulk-action-status-open'
    }, {
      name: _status.statuses[_domain.CaseStatuses['in-progress']].label,
      icon: getStatusIcon(_domain.CaseStatuses['in-progress']),
      onClick: () => handleUpdateCaseStatus(selectedCases, _domain.CaseStatuses['in-progress']),
      disabled: isDisabled || shouldDisableStatus(selectedCases),
      'data-test-subj': 'cases-bulk-action-status-in-progress',
      key: 'cases-bulk-action-status-in-progress'
    }, {
      name: _status.statuses[_domain.CaseStatuses.closed].label,
      icon: getStatusIcon(_domain.CaseStatuses.closed),
      onClick: () => handleUpdateCaseStatus(selectedCases, _domain.CaseStatuses.closed),
      disabled: isDisabled || shouldDisableStatus(selectedCases),
      'data-test-subj': 'cases-bulk-action-status-closed',
      key: 'cases-bulk-status-action'
    }];
  };
  return {
    getActions,
    canUpdateStatus: canUpdate || canReopenCase
  };
};
exports.useStatusAction = useStatusAction;