"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TheHiveFieldsRt = exports.SwimlaneFieldsRt = exports.SwimlaneConnectorType = exports.ServiceNowSIRFieldsRt = exports.ServiceNowITSMFieldsRt = exports.ResilientFieldsRt = exports.JiraFieldsRt = exports.ConnectorTypes = exports.ConnectorTypeFieldsRt = exports.ConnectorMappingsRt = exports.ConnectorMappingsAttributesRt = exports.CaseUserActionConnectorRt = exports.CaseConnectorRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ConnectorTypes = exports.ConnectorTypes = /*#__PURE__*/function (ConnectorTypes) {
  ConnectorTypes["casesWebhook"] = ".cases-webhook";
  ConnectorTypes["jira"] = ".jira";
  ConnectorTypes["none"] = ".none";
  ConnectorTypes["resilient"] = ".resilient";
  ConnectorTypes["serviceNowITSM"] = ".servicenow";
  ConnectorTypes["serviceNowSIR"] = ".servicenow-sir";
  ConnectorTypes["swimlane"] = ".swimlane";
  ConnectorTypes["theHive"] = ".thehive";
  return ConnectorTypes;
}({});
const ConnectorCasesWebhookTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.casesWebhook),
  fields: rt.null
});

/**
 * Jira
 */

const JiraFieldsRt = exports.JiraFieldsRt = rt.strict({
  issueType: rt.union([rt.string, rt.null]),
  priority: rt.union([rt.string, rt.null]),
  parent: rt.union([rt.string, rt.null])
});
const ConnectorJiraTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.jira),
  fields: rt.union([JiraFieldsRt, rt.null])
});

/**
 * Resilient
 */

const ResilientFieldsRt = exports.ResilientFieldsRt = rt.strict({
  incidentTypes: rt.union([rt.array(rt.string), rt.null]),
  severityCode: rt.union([rt.string, rt.null])
});
const ConnectorResilientTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.resilient),
  fields: rt.union([ResilientFieldsRt, rt.null])
});

/**
 * ServiceNow
 */

const ServiceNowITSMFieldsRt = exports.ServiceNowITSMFieldsRt = rt.intersection([rt.strict({
  impact: rt.union([rt.string, rt.null]),
  severity: rt.union([rt.string, rt.null]),
  urgency: rt.union([rt.string, rt.null]),
  category: rt.union([rt.string, rt.null]),
  subcategory: rt.union([rt.string, rt.null])
}), rt.exact(rt.partial({
  additionalFields: rt.union([rt.string, rt.null])
}))]);
const ConnectorServiceNowITSMTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.serviceNowITSM),
  fields: rt.union([ServiceNowITSMFieldsRt, rt.null])
});
const ServiceNowSIRFieldsRt = exports.ServiceNowSIRFieldsRt = rt.intersection([rt.strict({
  category: rt.union([rt.string, rt.null]),
  destIp: rt.union([rt.boolean, rt.null]),
  malwareHash: rt.union([rt.boolean, rt.null]),
  malwareUrl: rt.union([rt.boolean, rt.null]),
  priority: rt.union([rt.string, rt.null]),
  sourceIp: rt.union([rt.boolean, rt.null]),
  subcategory: rt.union([rt.string, rt.null])
}), rt.exact(rt.partial({
  additionalFields: rt.union([rt.string, rt.null])
}))]);
const ConnectorServiceNowSIRTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.serviceNowSIR),
  fields: rt.union([ServiceNowSIRFieldsRt, rt.null])
});

/**
 * Swimlane
 */

const SwimlaneFieldsRt = exports.SwimlaneFieldsRt = rt.strict({
  caseId: rt.union([rt.string, rt.null])
});
let SwimlaneConnectorType = exports.SwimlaneConnectorType = /*#__PURE__*/function (SwimlaneConnectorType) {
  SwimlaneConnectorType["All"] = "all";
  SwimlaneConnectorType["Alerts"] = "alerts";
  SwimlaneConnectorType["Cases"] = "cases";
  return SwimlaneConnectorType;
}({});
const ConnectorSwimlaneTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.swimlane),
  fields: rt.union([SwimlaneFieldsRt, rt.null])
});

/**
 * Thehive
 */

const TheHiveFieldsRt = exports.TheHiveFieldsRt = rt.strict({
  tlp: rt.union([rt.number, rt.null])
});
const ConnectorTheHiveTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.theHive),
  fields: rt.union([TheHiveFieldsRt, rt.null])
});

/**
 * None connector
 */

const ConnectorNoneTypeFieldsRt = rt.strict({
  type: rt.literal(ConnectorTypes.none),
  fields: rt.null
});
const ConnectorTypeFieldsRt = exports.ConnectorTypeFieldsRt = rt.union([ConnectorCasesWebhookTypeFieldsRt, ConnectorJiraTypeFieldsRt, ConnectorNoneTypeFieldsRt, ConnectorResilientTypeFieldsRt, ConnectorServiceNowITSMTypeFieldsRt, ConnectorServiceNowSIRTypeFieldsRt, ConnectorSwimlaneTypeFieldsRt, ConnectorTheHiveTypeFieldsRt]);

/**
 * This type represents the connector's format when it is encoded within a user action.
 */
const CaseUserActionConnectorRt = exports.CaseUserActionConnectorRt = rt.union([rt.intersection([ConnectorCasesWebhookTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorJiraTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorNoneTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorResilientTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorServiceNowITSMTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorServiceNowSIRTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorSwimlaneTypeFieldsRt, rt.strict({
  name: rt.string
})]), rt.intersection([ConnectorTheHiveTypeFieldsRt, rt.strict({
  name: rt.string
})])]);
const CaseConnectorRt = exports.CaseConnectorRt = rt.intersection([rt.strict({
  id: rt.string
}), CaseUserActionConnectorRt]);

/**
 * Mappings
 */

const ConnectorMappingActionTypeRt = rt.union([rt.literal('append'), rt.literal('nothing'), rt.literal('overwrite')]);
const ConnectorMappingSourceRt = rt.union([rt.literal('title'), rt.literal('description'), rt.literal('comments'), rt.literal('tags')]);
const ConnectorMappingTargetRt = rt.union([rt.string, rt.literal('not_mapped')]);
const ConnectorMappingRt = rt.strict({
  action_type: ConnectorMappingActionTypeRt,
  source: ConnectorMappingSourceRt,
  target: ConnectorMappingTargetRt
});
const ConnectorMappingsRt = exports.ConnectorMappingsRt = rt.array(ConnectorMappingRt);
const ConnectorMappingsAttributesRt = exports.ConnectorMappingsAttributesRt = rt.strict({
  mappings: ConnectorMappingsRt,
  owner: rt.string
});