"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateEmbeddableExpression = exports.fetchEmbeddableRenderable = exports.UpdateEmbeddableExpressionActionType = void 0;
var _reduxActions = require("redux-actions");
var _create_thunk = require("../../lib/create_thunk");
var _elements = require("./elements");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const UpdateEmbeddableExpressionActionType = exports.UpdateEmbeddableExpressionActionType = 'updateEmbeddableExpression';
const updateEmbeddableExpression = exports.updateEmbeddableExpression = (0, _reduxActions.createAction)(UpdateEmbeddableExpressionActionType);
const fetchEmbeddableRenderable = exports.fetchEmbeddableRenderable = (0, _create_thunk.createThunk)('fetchEmbeddableRenderable', ({
  dispatch,
  getState
}, elementId) => {
  const pageWithElement = getState().persistent.workpad.pages.find(page => {
    return page.elements.find(element => element.id === elementId) !== undefined;
  });
  if (pageWithElement) {
    const element = pageWithElement.elements.find(el => el.id === elementId);
    dispatch((0, _elements.fetchRenderable)(element));
  }
});