"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPluginApi = getPluginApi;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPluginApi(expressionsPluginSetup) {
  const registries = {
    elements: [],
    transformUIs: [],
    datasourceUIs: [],
    modelUIs: [],
    viewUIs: [],
    argumentUIs: [],
    tagUIs: [],
    transitions: []
  };
  const addToRegistry = registry => {
    return entries => {
      if (Array.isArray(entries)) {
        registry.push(...entries);
      } else {
        registry.push(entries);
      }
    };
  };
  const api = {
    // Functions, types and renderers are registered directly to expression plugin
    addFunctions: fns => {
      fns.forEach(fn => {
        expressionsPluginSetup.registerFunction(fn);
      });
    },
    addTypes: types => {
      types.forEach(type => {
        expressionsPluginSetup.registerType(type);
      });
    },
    addRenderers: renderers => {
      renderers.forEach(r => {
        // There is an issue of the canvas render definition not matching the expression render definition
        // due to our handlers needing additional methods.  For now, we are going to cast to get to the proper
        // type, but we should work with AppArch to figure out how the Handlers can be genericized
        expressionsPluginSetup.registerRenderer(r);
      });
    },
    // All these others are local to canvas, and they will only register on start
    addElements: addToRegistry(registries.elements),
    addTransformUIs: addToRegistry(registries.transformUIs),
    addDatasourceUIs: addToRegistry(registries.datasourceUIs),
    addModelUIs: addToRegistry(registries.modelUIs),
    addViewUIs: addToRegistry(registries.viewUIs),
    addArgumentUIs: addToRegistry(registries.argumentUIs),
    addTagUIs: addToRegistry(registries.tagUIs),
    addTransitions: addToRegistry(registries.transitions)
  };
  return {
    api,
    registries
  };
}