"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadingIndicator = exports.initLoadingIndicator = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let isActive = false;
const loadingCount$ = new _rxjs.BehaviorSubject(0);
const initLoadingIndicator = addLoadingCount => addLoadingCount(loadingCount$);
exports.initLoadingIndicator = initLoadingIndicator;
const loadingIndicator = exports.loadingIndicator = {
  show: () => {
    if (!isActive) {
      isActive = true;
      loadingCount$.next(1);
    }
  },
  hide: () => {
    if (isActive) {
      isActive = false;
      loadingCount$.next(0);
    }
  }
};