"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneSubgraphs = void 0;
var _functional = require("./aeroelastic/functional");
var _get_id = require("./get_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const cloneSubgraphs = nodes => {
  const idMap = (0, _functional.arrayToMap)(nodes.map(n => n.id));

  // We simultaneously provide unique id values for all elements (across all pages)
  // AND ensure that parent-child relationships are retained (via matching id values within page)
  Object.keys(idMap).forEach(key => idMap[key] = (0, _get_id.getId)(key.split('-')[0])); // new group names to which we can map

  // must return elements in the same order, for several reasons
  return nodes.map(element => ({
    ...element,
    id: idMap[element.id],
    position: {
      ...element.position,
      parent: element.position.parent ? idMap[element.position.parent] : null
    }
  }));
};
exports.cloneSubgraphs = cloneSubgraphs;