"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _general_config = require("./general_config");
var _filter_config = require("./filter_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getTitle: () => _i18n.i18n.translate('xpack.canvas.globalConfig.title', {
    defaultMessage: 'Workpad settings'
  }),
  getGeneralLabel: () => _i18n.i18n.translate('xpack.canvas.globalConfig.general', {
    defaultMessage: 'General'
  }),
  getFilterLabel: () => _i18n.i18n.translate('xpack.canvas.globalConfig.filter', {
    defaultMessage: 'Filter'
  })
};
const GlobalConfig = () => {
  const tabs = [{
    id: 'general',
    name: strings.getGeneralLabel(),
    content: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasSidebar__pop"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_general_config.GeneralConfig, null))
  }, {
    id: 'filter',
    name: strings.getFilterLabel(),
    content: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasSidebar__pop"
    }, /*#__PURE__*/_react.default.createElement(_filter_config.FilterConfig, null))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__sidebarHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, strings.getTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    size: "s"
  }));
};
exports.GlobalConfig = GlobalConfig;