"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderFunctions = exports.renderFunctionFactories = void 0;
var _debug = require("./debug");
var _error = require("./error");
var _image = require("./image");
var _markdown = require("./markdown");
var _metric = require("./metric");
var _pie = require("./pie");
var _plot = require("./plot");
var _repeat_image = require("./repeat_image");
var _reveal_image = require("./reveal_image");
var _progress = require("./progress");
var _shape = require("./shape");
var _text = require("./text");
var _table = require("./table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderFunctions = exports.renderFunctions = [_pie.pie, _plot.plot];
const renderFunctionFactories = exports.renderFunctionFactories = [_debug.debugRendererFactory, _error.errorRendererFactory, _image.imageRendererFactory, _markdown.markdownFactory, _markdown.markdownFactory, _metric.metricRendererFactory, _progress.progressRendererFactory, _repeat_image.repeatImageRendererFactory, _reveal_image.revealImageRendererFactory, _shape.shapeRendererFactory, _table.tableFactory, _text.textFactory];