"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.repeatImage = repeatImage;
var _repeat_image = require("../../../i18n/functions/dict/repeat_image");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function repeatImage() {
  const {
    help,
    args: argHelp
  } = _repeat_image.help;
  return {
    name: 'repeatImage',
    aliases: [],
    type: 'render',
    inputTypes: ['number'],
    help,
    args: {
      emptyImage: {
        types: ['string', 'null'],
        help: argHelp.emptyImage,
        default: null
      },
      image: {
        types: ['string', 'null'],
        help: argHelp.image,
        default: null
      },
      max: {
        types: ['number', 'null'],
        help: argHelp.max,
        default: 1000
      },
      size: {
        types: ['number'],
        default: 100,
        help: argHelp.size
      }
    },
    fn: async (count, args) => {
      const {
        elasticOutline,
        isValidUrl,
        resolveWithMissingImage
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../../public/lib')));
      if (args.emptyImage !== null && isValidUrl(args.emptyImage) && args.max === null) {
        throw new Error(_repeat_image.errors.getMissingMaxArgumentErrorMessage());
      }
      return {
        type: 'render',
        as: 'repeatImage',
        value: {
          count: Math.floor(count),
          ...args,
          image: resolveWithMissingImage(args.image, elasticOutline),
          emptyImage: resolveWithMissingImage(args.emptyImage)
        }
      };
    }
  };
}