"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmSourcesAccessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverRouteRepository = require("@kbn/server-route-repository");
var _apm_indices = require("./saved_objects/apm_indices");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * APM Source setup services
 */

/**
 * APM Source start services
 */

class ApmSourcesAccessPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "getApmIndices", async savedObjectsClient => {
      const apmIndicesFromSavedObject = await (0, _apm_indices.getApmIndicesSavedObject)(savedObjectsClient);
      return {
        ...this.config.indices,
        ...apmIndicesFromSavedObject
      };
    });
    this.config = initContext.config.get();
    this.logger = initContext.logger.get();
  }
  /**
   * Registers the saved object definition and ui settings
   * for APM Sources.
   */
  setup(core) {
    // register saved object
    core.savedObjects.registerType(_apm_indices.apmIndicesSavedObjectDefinition);
    const services = {
      apmIndicesFromConfigFile: this.config.indices,
      getApmIndices: this.getApmIndices
    };
    (0, _serverRouteRepository.registerRoutes)({
      core,
      logger: this.logger,
      repository: _routes.apmSourcesSettingsRouteRepository,
      dependencies: {
        sources: services
      }
    });

    // expose
    return services;
  }

  /**
   * Initialises the user value for APM Sources UI settings.
   */
  start() {
    return {
      getApmIndices: this.getApmIndices
    };
  }
  stop() {}
}
exports.ApmSourcesAccessPlugin = ApmSourcesAccessPlugin;