"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyDetectionRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _common = require("@kbn/observability-plugin/common");
var _get_es_capabilities = require("../../../lib/helpers/get_es_capabilities");
var _license_check = require("../../../../common/license_check");
var _anomaly_detection = require("../../../../common/anomaly_detection");
var _create_apm_server_route = require("../../apm_routes/create_apm_server_route");
var _create_anomaly_detection_jobs = require("../../../lib/anomaly_detection/create_anomaly_detection_jobs");
var _get_ml_client = require("../../../lib/helpers/get_ml_client");
var _get_all_environments = require("../../environments/get_all_environments");
var _transactions = require("../../../lib/helpers/transactions");
var _feature = require("../../../feature");
var _update_to_v = require("./update_to_v3");
var _environment_rt = require("../../../../common/environment_rt");
var _get_ml_jobs_with_apm_group = require("../../../lib/anomaly_detection/get_ml_jobs_with_apm_group");
var _get_apm_event_client = require("../../../lib/helpers/get_apm_event_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// get ML anomaly detection jobs for each environment
const anomalyDetectionJobsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/settings/anomaly-detection/jobs',
  security: {
    authz: {
      requiredPrivileges: ['apm', 'ml:canGetJobs']
    }
  },
  handler: async resources => {
    const mlClient = await (0, _get_ml_client.getMlClient)(resources);
    const {
      context
    } = resources;
    const licensingContext = await context.licensing;
    if (!(0, _license_check.isActivePlatinumLicense)(licensingContext.license)) {
      throw _boom.default.forbidden(_anomaly_detection.ML_ERRORS.INVALID_LICENSE);
    }
    if (!mlClient) {
      throw _boom.default.forbidden(_anomaly_detection.ML_ERRORS.ML_NOT_AVAILABLE);
    }
    const jobs = await (0, _get_ml_jobs_with_apm_group.getMlJobsWithAPMGroup)(mlClient === null || mlClient === void 0 ? void 0 : mlClient.anomalyDetectors);
    return {
      jobs,
      hasLegacyJobs: jobs.some(job => job.version === 1)
    };
  }
});

// create new ML anomaly detection jobs for each given environment
const createAnomalyDetectionJobsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/settings/anomaly-detection/jobs',
  security: {
    authz: {
      requiredPrivileges: ['apm', 'apm_settings_write', 'ml:canCreateJob']
    }
  },
  params: t.type({
    body: t.type({
      environments: t.array(_environment_rt.environmentStringRt)
    })
  }),
  handler: async resources => {
    const {
      params,
      context,
      logger,
      getApmIndices
    } = resources;
    const {
      environments
    } = params.body;
    const licensingContext = await context.licensing;
    const esClient = (await context.core).elasticsearch.client;
    const esCapabilities = await (0, _get_es_capabilities.getESCapabilities)(resources);
    const [mlClient, indices] = await Promise.all([(0, _get_ml_client.getMlClient)(resources), getApmIndices()]);
    if (!(0, _license_check.isActivePlatinumLicense)(licensingContext.license)) {
      throw _boom.default.forbidden(_anomaly_detection.ML_ERRORS.INVALID_LICENSE);
    }
    await (0, _create_anomaly_detection_jobs.createAnomalyDetectionJobs)({
      mlClient,
      esClient: esClient.asCurrentUser,
      indices,
      environments,
      logger,
      esCapabilities
    });
    (0, _feature.notifyFeatureUsage)({
      licensingPlugin: licensingContext,
      featureName: 'ml'
    });
    return {
      jobCreated: true
    };
  }
});

// get all available environments to create anomaly detection jobs for
const anomalyDetectionEnvironmentsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/settings/anomaly-detection/environments',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const coreContext = await resources.context.core;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config: resources.config,
      kuery: ''
    });
    const size = await coreContext.uiSettings.client.get(_common.maxSuggestions);
    const environments = await (0, _get_all_environments.getAllEnvironments)({
      includeMissing: true,
      searchAggregatedTransactions,
      apmEventClient,
      size
    });
    return {
      environments
    };
  }
});
const anomalyDetectionUpdateToV3Route = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/settings/anomaly-detection/update_to_v3',
  security: {
    authz: {
      requiredPrivileges: ['apm', 'apm_settings_write', 'ml:canCreateJob', 'ml:canGetJobs', 'ml:canCloseJob']
    }
  },
  handler: async resources => {
    const {
      getApmIndices
    } = resources;
    const [indices, mlClient, esClient] = await Promise.all([getApmIndices(), (0, _get_ml_client.getMlClient)(resources), resources.core.start().then(start => start.elasticsearch.client.asInternalUser)]);
    const esCapabilities = await (0, _get_es_capabilities.getESCapabilities)(resources);
    const {
      logger
    } = resources;
    return {
      update: await (0, _update_to_v.updateToV3)({
        mlClient,
        logger,
        indices,
        esClient,
        esCapabilities
      })
    };
  }
});
const anomalyDetectionRouteRepository = exports.anomalyDetectionRouteRepository = {
  ...anomalyDetectionJobsRoute,
  ...createAnomalyDetectionJobsRoute,
  ...anomalyDetectionEnvironmentsRoute,
  ...anomalyDetectionUpdateToV3Route
};