"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.delay = delay;
exports.disableConsoleWarning = disableConsoleWarning;
exports.expectTextsInDocument = expectTextsInDocument;
exports.expectTextsNotInDocument = expectTextsNotInDocument;
exports.getRenderedHref = getRenderedHref;
exports.mockMoment = mockMoment;
exports.mockNow = mockNow;
exports.renderWithContext = renderWithContext;
exports.renderWithTheme = renderWithTheme;
var _react = require("@testing-library/react");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _mock_apm_plugin_context = require("../context/apm_plugin/mock_apm_plugin_context");
var _url_params_context = require("../context/url_params_context/url_params_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* global jest */

// eslint-disable-next-line import/no-extraneous-dependencies

const originalConsoleWarn = console.warn; // eslint-disable-line no-console
/**
 *  A dependency we're using is using deprecated react methods. Override the
 * console to hide the warnings. These should go away when we switch to
 * Elastic Charts
 */
function disableConsoleWarning(messageToDisable) {
  return jest.spyOn(console, 'warn').mockImplementation(message => {
    if (!message.startsWith(messageToDisable)) {
      originalConsoleWarn(message);
    }
  });
}
function mockMoment() {
  // avoid timezone issues
  jest.spyOn(_moment.default.prototype, 'format').mockImplementation(function () {
    return `1st of January (mocking ${this.unix()})`;
  });

  // convert relative time to absolute time to avoid timing issues
  jest.spyOn(_moment.default.prototype, 'fromNow').mockImplementation(function () {
    return `1337 minutes ago (mocking ${this.unix()})`;
  });
}

// Useful for getting the rendered href from any kind of link component
async function getRenderedHref(Component, location) {
  var _el$container$querySe;
  const mockSpaces = {
    getActiveSpace: jest.fn().mockImplementation(() => ({
      id: 'mockSpaceId'
    }))
  };
  const el = (0, _react.render)(/*#__PURE__*/_react2.default.createElement(_reactRouterDom.MemoryRouter, {
    initialEntries: [location]
  }, /*#__PURE__*/_react2.default.createElement(_mock_apm_plugin_context.MockApmPluginContextWrapper, null, /*#__PURE__*/_react2.default.createElement(_public.KibanaContextProvider, {
    services: {
      spaces: mockSpaces
    }
  }, /*#__PURE__*/_react2.default.createElement(_url_params_context.UrlParamsProvider, null, /*#__PURE__*/_react2.default.createElement(Component, null))))));
  await (0, _react.waitFor)(() => el.container.querySelector('a') !== null, {
    container: el.container
  });
  return (_el$container$querySe = el.container.querySelector('a')) === null || _el$container$querySe === void 0 ? void 0 : _el$container$querySe.getAttribute('href');
}
function mockNow(date) {
  const fakeNow = new Date(date).getTime();
  return jest.spyOn(Date, 'now').mockReturnValue(fakeNow);
}
function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
function expectTextsNotInDocument(output, texts) {
  texts.forEach(text => {
    try {
      output.getByText(text);
    } catch (err) {
      if (err.message.startsWith('Unable to find an element with the text:')) {
        return;
      } else {
        throw err;
      }
    }
    throw new Error(`Unexpected text found: ${text}`);
  });
}
function expectTextsInDocument(output, texts) {
  texts.forEach(text => {
    expect(output.getByText(text)).toBeInTheDocument();
  });
}
function renderWithContext(component, params) {
  return (0, _react.render)(/*#__PURE__*/_react2.default.createElement(_mock_apm_plugin_context.MockApmPluginContextWrapper, null, /*#__PURE__*/_react2.default.createElement(_public.KibanaContextProvider, null, /*#__PURE__*/_react2.default.createElement(_url_params_context.UrlParamsProvider, null, /*#__PURE__*/_react2.default.createElement(_common.EuiThemeProvider, null, component)))), params);
}
function renderWithTheme(component, params) {
  return (0, _react.render)(/*#__PURE__*/_react2.default.createElement(_common.EuiThemeProvider, null, component), params);
}