"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceNameHint = exports.serviceEnvironmentHint = exports.serverUrlHint = exports.secretTokenHint = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceNameHint = exports.serviceNameHint = _i18n.i18n.translate('xpack.apm.tutorial.shared_clients.configure.commands.serviceNameHint', {
  defaultMessage: 'The service name is the primary filter in the APM UI and is used to group errors and trace data together. Allowed characters are a-z, A-Z, 0-9, -, _, and space.'
});
const secretTokenHint = exports.secretTokenHint = _i18n.i18n.translate('xpack.apm.tutorial.shared_clients.configure.commands.secretTokenHint', {
  defaultMessage: 'Use if APM Server requires a secret token. Both the agent and APM Server must be configured with the same token. This ensures that only your agents can send data to your APM server.'
});
const serverUrlHint = exports.serverUrlHint = _i18n.i18n.translate('xpack.apm.tutorial.shared_clients.configure.commands.serverUrlHint', {
  defaultMessage: 'Set the custom APM Server URL (default: {defaultApmServerUrl}). The URL must be fully qualified, including protocol (http or https) and port.',
  values: {
    defaultApmServerUrl: 'http://localhost:8200'
  }
});
const serviceEnvironmentHint = exports.serviceEnvironmentHint = _i18n.i18n.translate('xpack.apm.tutorial.shared_clients.configure.commands.serviceEnvironmentHint', {
  defaultMessage: `The name of the environment this service is deployed in, e.g., "production" or "staging". Environments allow you to easily filter data on a global level in the APM UI. It's important to be consistent when naming environments across agents.`
});