"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreferredServiceAnomalyTimeseries = usePreferredServiceAnomalyTimeseries;
var _get_preferred_service_anomaly_timeseries = require("../../common/anomaly_detection/get_preferred_service_anomaly_timeseries");
var _use_apm_service_context = require("../context/apm_service/use_apm_service_context");
var _use_environments_context = require("../context/environments_context/use_environments_context");
var _use_service_anomaly_timeseries_context = require("../context/service_anomaly_timeseries/use_service_anomaly_timeseries_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePreferredServiceAnomalyTimeseries(detectorType) {
  const {
    allAnomalyTimeseries
  } = (0, _use_service_anomaly_timeseries_context.useServiceAnomalyTimeseriesContext)();
  const {
    preferredEnvironment
  } = (0, _use_environments_context.useEnvironmentsContext)();
  const {
    fallbackToTransactions
  } = (0, _use_apm_service_context.useApmServiceContext)();
  return (0, _get_preferred_service_anomaly_timeseries.getPreferredServiceAnomalyTimeseries)({
    preferredEnvironment,
    fallbackToTransactions,
    detectorType,
    allAnomalyTimeseries
  });
}