"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFiltersForEmbeddableCharts = useFiltersForEmbeddableCharts;
var _react = require("react");
var _apm = require("../../common/es_fields/apm");
var _term_query = require("../../common/utils/term_query");
var _environment_query = require("../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFiltersForEmbeddableCharts({
  serviceName,
  environment
}) {
  return (0, _react.useMemo)(() => [...(0, _term_query.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _environment_query.environmentQuery)(environment)].map(query => ({
    meta: {},
    query
  })), [environment, serviceName]);
}