"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMAlertingFailedTransactionsChart = APMAlertingFailedTransactionsChart;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _failed_transaction_chart = _interopRequireDefault(require("../../../components/alerting/ui_components/alert_details_app_section/failed_transaction_chart"));
var _use_alerting_props = require("../use_alerting_props");
var _time_range_callout = require("../time_range_callout");
var _service_name_callout = require("../service_name_callout");
var _environment_filter_values = require("../../../../common/environment_filter_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function APMAlertingFailedTransactionsChart({
  rule,
  alert,
  serviceName,
  environment = _environment_filter_values.ENVIRONMENT_ALL.value,
  rangeFrom = 'now-15m',
  rangeTo = 'now',
  transactionType,
  transactionName,
  kuery = '',
  filters
}) {
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).valueOf() : undefined;
  const {
    transactionType: currentTransactionType,
    transactionTypes,
    setTransactionType,
    comparisonChartTheme,
    timeZone
  } = (0, _use_alerting_props.useAlertingProps)({
    rule,
    serviceName,
    rangeFrom,
    rangeTo,
    kuery,
    defaultTransactionType: transactionType
  });
  if (!rangeFrom || !rangeTo) {
    return /*#__PURE__*/_react.default.createElement(_time_range_callout.TimeRangeCallout, null);
  }
  if (!serviceName || !currentTransactionType) {
    return /*#__PURE__*/_react.default.createElement(_service_name_callout.ServiceNameCallout, null);
  }
  return /*#__PURE__*/_react.default.createElement(_failed_transaction_chart.default, {
    transactionType: currentTransactionType,
    transactionTypes: transactionTypes,
    setTransactionType: setTransactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: rangeFrom,
    end: rangeTo,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone,
    kuery: kuery,
    filters: filters,
    alertStart: alert.start,
    alertEnd: alertEnd
  });
}