"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpStatusBadge = HttpStatusBadge;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _status_codes = require("./status_codes");
var _http_status_code_to_color = require("../../../../utils/http_status_code_to_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HttpStatusBadge({
  status
}) {
  const label = _i18n.i18n.translate('xpack.apm.transactionDetails.statusCode', {
    defaultMessage: 'Status code'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _http_status_code_to_color.httpStatusCodeToColor)(status) || 'default',
    "data-test-subj": "httpStatusBadge"
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "apmHttpStatusBadge"
  }, status, " ", _status_codes.statusCodes[status.toString()])));
}