"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Welcome = Welcome;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana_url = require("../../../hooks/use_kibana_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Welcome({
  isModalVisible = false,
  onClose,
  onConfirm
}) {
  const servicesInventory = (0, _use_kibana_url.useKibanaUrl)('/plugins/apm/assets/services_inventory.png');
  if (!isModalVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    style: {
      width: '630px'
    },
    onCancel: onClose,
    onConfirm: onConfirm,
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "xpack.apm.welcome.button.open",
      fill: true,
      size: "s"
    }, _i18n.i18n.translate('xpack.apm.welcome.button.openSurvey', {
      defaultMessage: 'OK'
    })),
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      "data-test-subj": "apmWelcomeLinkExternal",
      href: "https://ela.st/new-experience-services",
      external: true
    }, _i18n.i18n.translate('xpack.apm.welcome.linkLabel', {
      defaultMessage: 'Learn more'
    })),
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.welcome.title', {
    defaultMessage: 'Welcome to our new experience!'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.welcome.body', {
    defaultMessage: 'You can now see services detected from logs alongside your APM-instrumented services in a single inventory so you can view all of your services in one place.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "xl",
    src: servicesInventory,
    alt: _i18n.i18n.translate('xpack.apm.welcome.image.alt', {
      defaultMessage: 'Image of the new experience of the service inventory, showing services detected from logs and APM-instrumented services'
    })
  })));
}