"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaxY = getMaxY;
exports.getResponseTimeTickFormatter = getResponseTimeTickFormatter;
var _is_finite_number = require("../../../../../common/utils/is_finite_number");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getResponseTimeTickFormatter(formatter) {
  return t => formatter(t).formatted;
}
function getMaxY(specs) {
  const values = specs === null || specs === void 0 ? void 0 : specs.flatMap(spec => spec.data).map(coord => coord.y).filter(_is_finite_number.isFiniteNumber);
  if (values !== null && values !== void 0 && values.length) {
    return Math.max(...values, 0);
  }
  return 0;
}