"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimezoneOffsetInMs = getTimezoneOffsetInMs;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimezoneOffsetInMs(time) {
  // @ts-expect-error moment types don't define defaultZone but it's there
  const zone = _momentTimezone.default.defaultZone ? _momentTimezone.default.defaultZone.name : _momentTimezone.default.tz.guess();

  // @ts-expect-error
  return _momentTimezone.default.tz.zone(zone).parse(time) * 60000;
}