"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeAttachment = RuntimeAttachment;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _discovery_rule = require("./discovery_rule");
var _default_discovery_rule = require("./default_discovery_rule");
var _edit_discovery_rule = require("./edit_discovery_rule");
var _java_agent_version_input = require("./java_agent_version_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_AGENT_VERSION = 'latest';
function RuntimeAttachment({
  isEnabled,
  onToggleEnable,
  discoveryRuleList,
  setDiscoveryRuleList,
  onDelete,
  editDiscoveryRuleId,
  onEdit,
  onChangeOperation,
  stagedOperationText,
  onChangeType,
  stagedTypeText,
  onChangeProbe,
  stagedProbeText,
  onCancel,
  onSubmit,
  onAddRule,
  operationTypes,
  toggleDescription,
  discoveryRulesDescription,
  showUnsavedWarning,
  onDragEnd,
  version,
  onChangeVersion,
  isValidVersion
}) {
  return /*#__PURE__*/_react.default.createElement("div", null, showUnsavedWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.unsavedRules', {
      defaultMessage: 'You have unsaved changes. Click "Save integration" to sync changes to the integration.'
    }),
    color: "warning",
    iconType: "info",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.enableRuntimeAttachement', {
      defaultMessage: 'Enable runtime attachment'
    }),
    checked: isEnabled,
    onChange: onToggleEnable
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, toggleDescription))), isEnabled && /*#__PURE__*/_react.default.createElement(_java_agent_version_input.JavaAgentVersionInput, {
    version: version || DEFAULT_AGENT_VERSION,
    onChange: onChangeVersion,
    isValid: isValidVersion
  })), isEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.discoveryRules', {
    defaultMessage: 'Discovery rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, discoveryRulesDescription))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmRuntimeAttachmentAddRuleButton",
    iconType: "plusInCircle",
    disabled: editDiscoveryRuleId !== null,
    onClick: onAddRule
  }, _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.addRule', {
    defaultMessage: 'Add rule'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "RUNTIME_ATTACHMENT_DROPPABLE"
  }, discoveryRuleList.map(({
    discoveryRule,
    id
  }, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    key: id,
    index: idx,
    draggableId: id,
    customDragHandle: true
  }, provided => id === editDiscoveryRuleId ? /*#__PURE__*/_react.default.createElement(_edit_discovery_rule.EditDiscoveryRule, {
    id: editDiscoveryRuleId,
    onChangeOperation: onChangeOperation,
    operation: stagedOperationText,
    onChangeType: onChangeType,
    type: stagedTypeText,
    onChangeProbe: onChangeProbe,
    probe: stagedProbeText,
    onCancel: onCancel,
    onSubmit: onSubmit,
    operationTypes: operationTypes
  }) : /*#__PURE__*/_react.default.createElement(_discovery_rule.DiscoveryRule, {
    id: id,
    order: idx + 1,
    operation: discoveryRule.operation,
    type: discoveryRule.type,
    probe: discoveryRule.probe,
    providedDragHandleProps: provided.dragHandleProps,
    onDelete: onDelete,
    onEdit: onEdit,
    operationTypes: operationTypes
  }))))), /*#__PURE__*/_react.default.createElement(_default_discovery_rule.DefaultDiscoveryRule, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}