"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentList = AgentList;
exports.getAgentsColumns = getAgentsColumns;
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _agent_explorer = require("../../../../../../common/agent_explorer");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _environment_badge = require("../../../../shared/environment_badge");
var _item_badge = require("../../../../shared/item_badge");
var _managed_table = require("../../../../shared/managed_table");
var _truncate_with_tooltip = require("../../../../shared/truncate_with_tooltip");
var _agent_explorer_docs_link = require("../agent_explorer_docs_link");
var _agent_instances = require("../agent_instances");
var _agent_latest_version = require("../agent_latest_version");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAgentsColumns({
  selectedAgent,
  isLatestVersionsLoading,
  latestAgentVersionEnabled,
  latestVersionsFailed,
  onAgentSelected
}) {
  return [{
    field: _agent_explorer.AgentExplorerFieldName.ServiceName,
    name: '',
    width: '5%',
    render: (_, agent) => {
      const isSelected = selectedAgent === agent;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.apm.agentExplorerTable.viewAgentInstances', {
          defaultMessage: 'Toggle agent instances view'
        }),
        delay: "long"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        size: "xs",
        iconSize: "s",
        "aria-label": _i18n.i18n.translate('xpack.apm.getAgentsColumns.euiButtonIcon.toggleAgentInstancesViewLabel', {
          defaultMessage: 'Toggle agent instances view'
        }),
        "data-test-subj": "apmAgentExplorerListToggle",
        onClick: () => onAgentSelected(agent),
        display: isSelected ? 'base' : 'empty',
        iconType: isSelected ? 'minimize' : 'expand',
        isSelected: isSelected
      }));
    }
  }, {
    field: _agent_explorer.AgentExplorerFieldName.ServiceName,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerTable.serviceNameColumnLabel', {
      defaultMessage: 'Service Name'
    }),
    sortable: true,
    width: '35%',
    truncateText: true,
    render: (_, {
      serviceName,
      agentName
    }) => /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      "data-test-subj": "apmAgentExplorerListServiceLink",
      text: serviceName,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
        agentName: agentName,
        size: "l",
        role: "presentation"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        className: "eui-textTruncate"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "eui-textTruncate"
      }, serviceName)))
    })
  }, {
    field: _agent_explorer.AgentExplorerFieldName.Environments,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerTable.environmentColumnLabel', {
      defaultMessage: 'Environment'
    }),
    width: '15%',
    truncateText: true,
    sortable: true,
    render: (_, {
      environments
    }) => /*#__PURE__*/_react.default.createElement(_environment_badge.EnvironmentBadge, {
      environments: environments
    })
  }, {
    field: _agent_explorer.AgentExplorerFieldName.Instances,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerTable.instancesColumnLabel', {
      defaultMessage: 'Instances'
    }),
    width: '10%',
    sortable: true
  }, {
    field: _agent_explorer.AgentExplorerFieldName.AgentName,
    width: '15%',
    name: _i18n.i18n.translate('xpack.apm.agentExplorerTable.agentNameColumnLabel', {
      defaultMessage: 'Agent Name'
    }),
    sortable: true
  }, {
    field: _agent_explorer.AgentExplorerFieldName.AgentVersion,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerTable.agentVersionColumnLabel', {
      defaultMessage: 'Agent Version'
    }),
    width: '10%',
    truncateText: true,
    render: (_, {
      agentVersion
    }) => /*#__PURE__*/_react.default.createElement(_item_badge.ItemsBadge, {
      items: agentVersion,
      multipleItemsMessage: _i18n.i18n.translate('xpack.apm.agentExplorerTable.agentVersionColumnLabel.multipleVersions', {
        values: {
          versionsCount: agentVersion.length
        },
        defaultMessage: '{versionsCount, plural, one {1 version} other {# versions}}'
      })
    })
  }, ...(latestAgentVersionEnabled ? [{
    field: _agent_explorer.AgentExplorerFieldName.AgentLastVersion,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.agentExplorerTable.agentLatestVersionColumnTooltip', {
        defaultMessage: 'The latest released version of the agent.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.agentExplorerTable.agentLatestVersionColumnLabel', {
      defaultMessage: 'Latest Agent Version'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignCenter"
    }))),
    width: '10%',
    align: 'center',
    truncateText: true,
    render: (_, {
      agentName,
      latestVersion
    }) => /*#__PURE__*/_react.default.createElement(_agent_latest_version.AgentLatestVersion, {
      agentName: agentName,
      isLoading: isLatestVersionsLoading,
      latestVersion: latestVersion,
      failed: latestVersionsFailed
    })
  }] : []), {
    field: _agent_explorer.AgentExplorerFieldName.AgentDocsPageUrl,
    name: _i18n.i18n.translate('xpack.apm.agentExplorerTable.agentDocsColumnLabel', {
      defaultMessage: 'Agent Docs'
    }),
    width: '10%',
    truncateText: true,
    render: (_, {
      agentName,
      agentDocsPageUrl
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: `${agentName} agent docs`
    }, /*#__PURE__*/_react.default.createElement(_agent_explorer_docs_link.AgentExplorerDocsLink, {
      agentName: agentName,
      repositoryUrl: agentDocsPageUrl
    }))
  }];
}
function AgentList({
  items,
  noItemsMessage,
  isLoading,
  isLatestVersionsLoading,
  latestVersionsFailed
}) {
  const {
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const latestAgentVersionEnabled = !(0, _lodash.isEmpty)(config.latestAgentVersionsUrl);
  const [selectedAgent, setSelectedAgent] = (0, _react.useState)();
  const onAgentSelected = agent => {
    setSelectedAgent(agent);
  };
  const onCloseFlyout = () => {
    setSelectedAgent(undefined);
  };
  const agentColumns = (0, _react.useMemo)(() => getAgentsColumns({
    selectedAgent,
    isLatestVersionsLoading,
    latestAgentVersionEnabled,
    latestVersionsFailed,
    onAgentSelected
  }), [selectedAgent, latestAgentVersionEnabled, isLatestVersionsLoading, latestVersionsFailed]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedAgent && /*#__PURE__*/_react.default.createElement(_agent_instances.AgentInstances, {
    agent: selectedAgent,
    isLatestVersionsLoading: isLatestVersionsLoading,
    latestVersionsFailed: latestVersionsFailed,
    onClose: onCloseFlyout
  }), /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    columns: agentColumns,
    items: items,
    noItemsMessage: noItemsMessage,
    initialSortField: _agent_explorer.AgentExplorerFieldName.Instances,
    initialSortDirection: "desc",
    isLoading: isLoading,
    initialPageSize: 25
  }));
}