"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParentRelationshipAnalysis = ParentRelationshipAnalysis;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ParentRelationshipAnalysis({
  hasParent,
  destinationHits,
  sourceNode,
  destinationNode
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsTitle', {
    defaultMessage: 'Parent Relationship Analysis'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), hasParent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsFound', {
    defaultMessage: 'Parent relationships found for {destinationNode}',
    values: {
      destinationNode
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: '{count, plural, one {# document} other {# documents}}',
    values: {
      count: destinationHits.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsFoundDescription', {
    defaultMessage: 'Found {count, plural, one {# document} other {# documents}} showing parent relationships pointing to {destinationNode} from {sourceNode} during the selected time range.',
    values: {
      count: destinationHits.length,
      destinationNode,
      sourceNode
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFound', {
    defaultMessage: 'No parent relationships found for {destinationNode}',
    values: {
      destinationNode
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: '{count, plural, one {# document} other {# documents}}',
    values: {
      count: destinationHits.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFoundDescription', {
    defaultMessage: 'No parent IDs were found pointing from {sourceNode} to {destinationNode} during the selected time range. Found {count, plural, one {# document} other {# documents}} for analysis. This could indicate:',
    values: {
      sourceNode,
      destinationNode,
      count: destinationHits.length
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      marginTop: euiTheme.size.s,
      paddingLeft: euiTheme.size.base
    }
  }, /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFoundReason1', {
    defaultMessage: 'An instrumentation issue preventing proper trace correlation'
  })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFoundReason2', {
    defaultMessage: 'Missing distributed tracing configuration between services'
  }))))));
}