"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileServiceOverview = MobileServiceOverview;
exports.chartHeight = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _annotations_context = require("../../../../context/annotations/annotations_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _service_overview_throughput_chart = require("../../service_overview/service_overview_throughput_chart");
var _transactions_table = require("../../../shared/transactions_table");
var _most_used_charts = require("./most_used_charts");
var _geo_map = require("./geo_map");
var _failed_transaction_rate_chart = require("../../../shared/charts/failed_transaction_rate_chart");
var _service_overview_dependencies_table = require("../../service_overview/service_overview_dependencies_table");
var _latency_chart = require("../../../shared/charts/latency_chart");
var _use_filters_for_embeddable_charts = require("../../../../hooks/use_filters_for_embeddable_charts");
var _get_kuery_with_mobile_filters = require("../../../../../common/utils/get_kuery_with_mobile_filters");
var _stats = require("./stats/stats");
var _location_stats = require("./stats/location_stats");
var _use_adhoc_apm_data_view = require("../../../../hooks/use_adhoc_apm_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The height a chart should be if it's next to a table with 5 rows and a title.
 * Add the height of the pagination row.
 */
const chartHeight = exports.chartHeight = 288;
function MobileServiceOverview() {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const {
    query,
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      device,
      osVersion,
      appVersion,
      netConnectionType,
      offset,
      comparisonEnabled,
      transactionType
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/overview');
  const embeddableFilters = (0, _use_filters_for_embeddable_charts.useFiltersForEmbeddableCharts)({
    serviceName,
    environment
  });
  const kueryWithMobileFilters = (0, _get_kuery_with_mobile_filters.getKueryWithMobileFilters)({
    device,
    osVersion,
    appVersion,
    netConnectionType,
    kuery
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const dependenciesLink = router.link('/services/{serviceName}/dependencies', {
    path: {
      serviceName
    },
    query
  });

  // The default EuiFlexGroup breaks at 768, but we want to break at 1200, so we
  // observe the window width and set the flex directions of rows accordingly
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const isSingleColumn = isLarge;
  const latencyChartHeight = 200;
  const nonLatencyChartHeight = isSingleColumn ? latencyChartHeight : chartHeight;
  const rowDirection = isSingleColumn ? 'column' : 'row';
  return /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_stats.MobileStats, {
    start: start,
    end: end,
    kuery: kueryWithMobileFilters
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 8
  }, /*#__PURE__*/_react.default.createElement(_geo_map.GeoMap, {
    start: start,
    end: end,
    kuery: kueryWithMobileFilters,
    filters: embeddableFilters,
    dataView: dataView
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_location_stats.MobileLocationStats, {
    start: start,
    end: end,
    kuery: kueryWithMobileFilters,
    environment: environment,
    offset: offset,
    serviceName: serviceName,
    comparisonEnabled: comparisonEnabled
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceOverview.mostUsedTitle', {
    defaultMessage: 'Most used'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_most_used_charts.MostUsedCharts, {
    kuery: kueryWithMobileFilters,
    start: start,
    end: end,
    environment: environment,
    transactionType: transactionType,
    serviceName: serviceName
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.LatencyChart, {
    height: latencyChartHeight,
    kuery: kueryWithMobileFilters
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_service_overview_throughput_chart.ServiceOverviewThroughputChart, {
    height: nonLatencyChartHeight,
    kuery: kueryWithMobileFilters
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_transactions_table.TransactionsTable, {
    kuery: kueryWithMobileFilters,
    environment: environment,
    fixedHeight: true,
    start: start,
    end: end,
    showPerPageOptions: false
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    height: nonLatencyChartHeight,
    showAnnotations: false,
    kuery: kueryWithMobileFilters
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_service_overview_dependencies_table.ServiceOverviewDependenciesTable, {
    fixedHeight: true,
    showPerPageOptions: false,
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmMobileServiceOverviewViewDependenciesLink",
      href: dependenciesLink
    }, _i18n.i18n.translate('xpack.apm.serviceOverview.dependenciesTableTabLink', {
      defaultMessage: 'View dependencies'
    }))
  }))))))));
}