"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMapSelect = EmbeddedMapSelect;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/mobile/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  value: _constants.MapTypes.Http,
  label: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.dropdown.http.requests', {
    defaultMessage: 'HTTP requests'
  }),
  description: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.dropdown.http.requests.subtitle', {
    defaultMessage: 'HTTP defines a set of request methods to indicate the desired action to be performed for a given resource'
  })
}, {
  value: _constants.MapTypes.Session,
  label: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.dropdown.sessions', {
    defaultMessage: 'Sessions'
  }),
  description: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.dropdown.sessions.subtitle', {
    defaultMessage: 'An application session begins when a user starts an application and ends when the application exits.'
  })
}].map(({
  value,
  label,
  description
}) => ({
  inputDisplay: label,
  value,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, description)))
}));
function EmbeddedMapSelect({
  selectedMap,
  onChange
}) {
  var _options$find;
  const currentMap = (_options$find = options.find(({
    value
  }) => value === selectedMap)) !== null && _options$find !== void 0 ? _options$find : options[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.title', {
    defaultMessage: 'Geographic regions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.subtitle', {
    defaultMessage: 'Map showing the total number of {currentMap} based on country and region',
    values: {
      currentMap: currentMap.inputDisplay
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    style: {
      minWidth: '200px'
    },
    options: options,
    valueOfSelected: selectedMap,
    onChange: onChange,
    itemLayoutAlign: "top",
    hasDividers: true
  }));
}