"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessMetrics = ServerlessMetrics;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _serverless_functions = require("./serverless_functions");
var _serverless_summary = require("./serverless_summary");
var _serverless_active_instances = require("./serverless_active_instances");
var _serverless_metrics_charts = require("./serverless_metrics_charts");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServerlessMetrics({
  serverlessId
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_serverless_summary.ServerlessSummary, {
    serverlessId: serverlessId
  })), !serverlessId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_serverless_functions.ServerlessFunctions, null)), /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_serverless_metrics_charts.ServerlessMetricsCharts, {
    serverlessId: serverlessId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_serverless_active_instances.ServerlessActiveInstances, {
    serverlessId: serverlessId
  }))));
}