"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedTransactionsCorrelationImpactLabel = getFailedTransactionsCorrelationImpactLabel;
exports.getLatencyCorrelationImpactLabel = getLatencyCorrelationImpactLabel;
var _constants = require("../../../../../common/correlations/failed_transactions_correlations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFailedTransactionsCorrelationImpactLabel(pValue, isFallbackResult) {
  if (pValue === null) {
    return null;
  }
  if (isFallbackResult) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.VERY_LOW,
    color: 'default'
  };

  // The lower the p value, the higher the impact
  if (pValue >= 0 && pValue < 1e-6) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.HIGH,
    color: 'danger'
  };
  if (pValue >= 1e-6 && pValue < 0.001) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.MEDIUM,
    color: 'warning'
  };
  if (pValue >= 0.001 && pValue < 0.02) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.LOW,
    color: 'default'
  };
  return null;
}
function getLatencyCorrelationImpactLabel(correlation, isFallbackResult) {
  if (correlation === null || correlation < 0) {
    return null;
  }

  // The lower the p value, the higher the impact
  if (isFallbackResult) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.VERY_LOW,
    color: 'default'
  };
  if (correlation < 0.4) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.LOW,
    color: 'default'
  };
  if (correlation < 0.6) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.MEDIUM,
    color: 'warning'
  };
  if (correlation < 1) return {
    impact: _constants.CORRELATIONS_IMPACT_THRESHOLD.HIGH,
    color: 'danger'
  };
  return null;
}