"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsProgressControls = CorrelationsProgressControls;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CorrelationsProgressControls({
  progress,
  onRefresh,
  onCancel,
  isRunning
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "apmCorrelationsProgressTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "apmCorrelationsProgressTitleMessage",
    id: "xpack.apm.correlations.progressTitle",
    defaultMessage: "Progress: {progress}%",
    values: {
      progress: Math.round(progress * 100)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "aria-label": _i18n.i18n.translate('xpack.apm.correlations.progressAriaLabel', {
      defaultMessage: 'Progress'
    }),
    value: Math.round(progress * 100),
    max: 100,
    size: "m"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !isRunning && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmCorrelationsProgressControlsRefreshButton",
    size: "s",
    onClick: onRefresh
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.refreshButtonTitle",
    defaultMessage: "Refresh"
  })), isRunning && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmCorrelationsProgressControlsCancelButton",
    size: "s",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.cancelButtonTitle",
    defaultMessage: "Cancel"
  }))));
}