"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessType = void 0;
exports.getServerlessFunctionNameFromId = getServerlessFunctionNameFromId;
exports.getServerlessTypeFromCloudData = getServerlessTypeFromCloudData;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the serverless function name from serverless id.
 * Serverless id example: arn:aws:lambda:us-west-2:123456789012:function:my-function
 * The function name is the last part after "function:"
 */
const serverlessIdRegex = /function:(.*)/;
function getServerlessFunctionNameFromId(serverlessId) {
  const match = serverlessIdRegex.exec(serverlessId);
  return match ? match[1] : serverlessId;
}
let ServerlessType = exports.ServerlessType = /*#__PURE__*/function (ServerlessType) {
  ServerlessType["AWS_LAMBDA"] = "aws.lambda";
  ServerlessType["AZURE_FUNCTIONS"] = "azure.functions";
  return ServerlessType;
}({});
function getServerlessTypeFromCloudData(cloudProvider, cloudServiceName) {
  if ((cloudProvider === null || cloudProvider === void 0 ? void 0 : cloudProvider.toLowerCase()) === 'aws' && (cloudServiceName === null || cloudServiceName === void 0 ? void 0 : cloudServiceName.toLowerCase()) === 'lambda') {
    return ServerlessType.AWS_LAMBDA;
  }
  if ((cloudProvider === null || cloudProvider === void 0 ? void 0 : cloudProvider.toLowerCase()) === 'azure' && (cloudServiceName === null || cloudServiceName === void 0 ? void 0 : cloudServiceName.toLowerCase()) === 'functions') {
    return ServerlessType.AZURE_FUNCTIONS;
  }
}