"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetHostNames = createGetHostNames;
var _server = require("@kbn/observability-plugin/server");
var _es_fields = require("@kbn/apm-types/es_fields");
var _lodash = require("lodash");
var _common = require("../../../common");
var _get_preferred_bucket_size_and_data_source = require("../../../common/utils/get_preferred_bucket_size_and_data_source");
var _document_type = require("../../../common/document_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_SIZE = 1000;
const suitableTypes = [_document_type.ApmDocumentType.TransactionMetric];
function createGetHostNames({
  apmEventClient
}) {
  return async ({
    start,
    end,
    size = MAX_SIZE,
    query,
    documentSources
  }) => {
    var _esResponse$aggregati, _esResponse$aggregati2;
    const sourcesToUse = (0, _get_preferred_bucket_size_and_data_source.getPreferredBucketSizeAndDataSource)({
      sources: documentSources.filter(s => suitableTypes.includes(s.documentType)),
      bucketSizeInSeconds: (0, _common.getBucketSize)({
        start,
        end,
        numBuckets: 50
      }).bucketSize
    });
    const esResponse = await apmEventClient.search('get_apm_host_names', {
      apm: {
        sources: [{
          documentType: sourcesToUse.source.documentType,
          rollupInterval: sourcesToUse.source.rollupInterval
        }]
      },
      body: {
        track_total_hits: false,
        size: 0,
        query: {
          bool: {
            filter: [...(0, _lodash.castArray)(query), ...(0, _server.rangeQuery)(start, end)]
          }
        },
        aggs: {
          hostNames: {
            terms: {
              field: _es_fields.HOST_NAME,
              size: Math.min(size, MAX_SIZE),
              order: {
                _key: 'asc'
              }
            }
          }
        }
      }
    });
    return (_esResponse$aggregati = (_esResponse$aggregati2 = esResponse.aggregations) === null || _esResponse$aggregati2 === void 0 ? void 0 : _esResponse$aggregati2.hostNames.buckets.map(bucket => bucket.key)) !== null && _esResponse$aggregati !== void 0 ? _esResponse$aggregati : [];
  };
}