"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initApm = void 0;
var _config_loader = require("./config_loader");
var _pii_filter = require("./filters/pii_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initApm = (argv, rootDir, isDistributable, serviceName) => {
  const apmConfigLoader = (0, _config_loader.loadConfiguration)(argv, rootDir, isDistributable);
  const apmConfig = apmConfigLoader.getConfig(serviceName);
  const shouldRedactUsers = apmConfigLoader.isUsersRedactionEnabled();

  // we want to only load the module when effectively used
  // eslint-disable-next-line @typescript-eslint/no-var-requires
  const apm = require('elastic-apm-node');

  // Filter out all user PII
  if (shouldRedactUsers) {
    apm.addFilter(_pii_filter.piiFilter);
  }
  apm.start(apmConfig);
};
exports.initApm = initApm;