"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrappedStateRt = exports.alertTypeStateRt = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trackedAlertStateRt = t.type({
  alertId: t.string,
  alertUuid: t.string,
  started: t.string,
  // an array used to track changes in alert state, the order is based on the rule executions
  // true - alert has changed from active/recovered
  // false - alert is new or the status has remained either active or recovered
  flappingHistory: t.array(t.boolean),
  // flapping flag that indicates whether the alert is flapping
  flapping: t.boolean,
  // count of consecutive recovered alerts for flapping
  // will reset if the alert is active or if equal to the statusChangeThreshold stored in the rule settings
  pendingRecoveredCount: t.number,
  // count of consecutive active alerts will reset if the alert is recovered
  activeCount: t.number
});
const alertTypeStateRt = () => t.record(t.string, t.unknown);
exports.alertTypeStateRt = alertTypeStateRt;
const wrappedStateRt = () => t.type({
  wrapped: alertTypeStateRt(),
  // tracks the active alerts
  trackedAlerts: t.record(t.string, trackedAlertStateRt),
  // tracks the recovered alerts
  trackedAlertsRecovered: t.record(t.string, trackedAlertStateRt)
});

/**
 * This is redefined instead of derived from above `wrappedStateRt` because
 * there's no easy way to instantiate generic values such as the runtime type
 * factory function.
 */
exports.wrappedStateRt = wrappedStateRt;