"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildRuleUrl = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildRuleUrl = opts => {
  if (!opts.kibanaBaseUrl) {
    return;
  }
  const relativePath = opts.getViewInAppRelativeUrl ? opts.getViewInAppRelativeUrl({
    rule: opts.rule,
    start: opts.start,
    end: opts.end
  }) : `${_ruleDataUtils.triggersActionsRoute}${(0, _ruleDataUtils.getRuleDetailsRoute)(opts.rule.id)}`;
  try {
    const basePathname = new URL(opts.kibanaBaseUrl).pathname;
    const basePathnamePrefix = basePathname !== '/' ? `${basePathname}` : '';
    const spaceIdSegment = opts.spaceId !== 'default' ? `/s/${opts.spaceId}` : '';
    const ruleUrl = new URL([basePathnamePrefix, spaceIdSegment, relativePath].join(''), opts.kibanaBaseUrl);
    return {
      absoluteUrl: ruleUrl.toString(),
      kibanaBaseUrl: opts.kibanaBaseUrl,
      basePathname: basePathnamePrefix,
      spaceIdSegment,
      relativePath
    };
  } catch (error) {
    opts.logger.debug(`Rule "${opts.rule.id}" encountered an error while constructing the rule.url variable: ${error.message}`);
    return;
  }
};
exports.buildRuleUrl = buildRuleUrl;