"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTypeIdWithValidLegacyConsumers = exports.getRuleTypeIdValidLegacyConsumers = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypeIdWithValidLegacyConsumers = exports.ruleTypeIdWithValidLegacyConsumers = {
  'example.always-firing': [_types.ALERTING_FEATURE_ID],
  'example.people-in-space': [_types.ALERTING_FEATURE_ID],
  transform_health: [_types.ALERTING_FEATURE_ID],
  '.index-threshold': [_types.ALERTING_FEATURE_ID],
  '.geo-containment': [_types.ALERTING_FEATURE_ID],
  '.es-query': [_types.ALERTING_FEATURE_ID, 'discover'],
  'xpack.ml.anomaly_detection_alert': [_types.ALERTING_FEATURE_ID],
  'xpack.ml.anomaly_detection_jobs_health': [_types.ALERTING_FEATURE_ID],
  'xpack.synthetics.alerts.monitorStatus': [_types.ALERTING_FEATURE_ID],
  'xpack.synthetics.alerts.tls': [_types.ALERTING_FEATURE_ID],
  'xpack.uptime.alerts.monitorStatus': [_types.ALERTING_FEATURE_ID],
  'xpack.uptime.alerts.tlsCertificate': [_types.ALERTING_FEATURE_ID],
  'xpack.uptime.alerts.durationAnomaly': [_types.ALERTING_FEATURE_ID],
  'xpack.uptime.alerts.tls': [_types.ALERTING_FEATURE_ID],
  'siem.eqlRule': [_types.ALERTING_FEATURE_ID],
  'siem.savedQueryRule': [_types.ALERTING_FEATURE_ID],
  'siem.indicatorRule': [_types.ALERTING_FEATURE_ID],
  'siem.mlRule': [_types.ALERTING_FEATURE_ID],
  'siem.queryRule': [_types.ALERTING_FEATURE_ID],
  'siem.thresholdRule': [_types.ALERTING_FEATURE_ID],
  'siem.newTermsRule': [_types.ALERTING_FEATURE_ID],
  'siem.notifications': [_types.ALERTING_FEATURE_ID],
  'slo.rules.burnRate': [_types.ALERTING_FEATURE_ID],
  'logs.alert.document.count': [_types.ALERTING_FEATURE_ID],
  'metrics.alert.inventory.threshold': [_types.ALERTING_FEATURE_ID],
  'metrics.alert.threshold': [_types.ALERTING_FEATURE_ID],
  monitoring_alert_cluster_health: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_license_expiration: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_cpu_usage: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_missing_monitoring_data: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_disk_usage: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_thread_pool_search_rejections: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_thread_pool_write_rejections: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_jvm_memory_usage: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_nodes_changed: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_logstash_version_mismatch: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_kibana_version_mismatch: [_types.ALERTING_FEATURE_ID],
  monitoring_alert_elasticsearch_version_mismatch: [_types.ALERTING_FEATURE_ID],
  monitoring_ccr_read_exceptions: [_types.ALERTING_FEATURE_ID],
  monitoring_shard_size: [_types.ALERTING_FEATURE_ID],
  'apm.transaction_duration': [_types.ALERTING_FEATURE_ID],
  'apm.anomaly': [_types.ALERTING_FEATURE_ID],
  'apm.error_rate': [_types.ALERTING_FEATURE_ID],
  'apm.transaction_error_rate': [_types.ALERTING_FEATURE_ID],
  'test.always-firing': [_types.ALERTING_FEATURE_ID],
  'test.always-firing-alert-as-data': [_types.ALERTING_FEATURE_ID],
  'test.authorization': [_types.ALERTING_FEATURE_ID],
  'test.cancellableRule': [_types.ALERTING_FEATURE_ID],
  'test.cumulative-firing': [_types.ALERTING_FEATURE_ID],
  'test.exceedsAlertLimit': [_types.ALERTING_FEATURE_ID],
  'test.failing': [_types.ALERTING_FEATURE_ID],
  'test.gold.noop': [_types.ALERTING_FEATURE_ID],
  'test.longRunning': [_types.ALERTING_FEATURE_ID],
  'test.multipleSearches': [_types.ALERTING_FEATURE_ID],
  'test.never-firing': [_types.ALERTING_FEATURE_ID],
  'test.noop': [_types.ALERTING_FEATURE_ID],
  'test.onlyContextVariables': [_types.ALERTING_FEATURE_ID],
  'test.onlyStateVariables': [_types.ALERTING_FEATURE_ID],
  'test.patternFiring': [_types.ALERTING_FEATURE_ID],
  'test.patternFiringAad': [_types.ALERTING_FEATURE_ID],
  'test.patternFiringAutoRecoverFalse': [_types.ALERTING_FEATURE_ID],
  'test.patternLongRunning': [_types.ALERTING_FEATURE_ID],
  'test.patternLongRunning.cancelAlertsOnRuleTimeout': [_types.ALERTING_FEATURE_ID],
  'test.patternSuccessOrFailure': [_types.ALERTING_FEATURE_ID],
  'test.restricted-noop': [_types.ALERTING_FEATURE_ID],
  'test.severity': [_types.ALERTING_FEATURE_ID],
  'test.throw': [_types.ALERTING_FEATURE_ID],
  'test.unrestricted-noop': [_types.ALERTING_FEATURE_ID],
  'test.validation': [_types.ALERTING_FEATURE_ID]
};
const getRuleTypeIdValidLegacyConsumers = ruleTypeId => {
  if (ruleTypeIdWithValidLegacyConsumers[ruleTypeId]) {
    return ruleTypeIdWithValidLegacyConsumers[ruleTypeId];
  }
  return [];
};
exports.getRuleTypeIdValidLegacyConsumers = getRuleTypeIdValidLegacyConsumers;