"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRuleToRuleResponse = exports.transformRuleLastRun = exports.transformRuleActions = exports.transformMonitoring = exports.transformFlapping = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRuleLastRun = lastRun => {
  return {
    outcome: lastRun.outcome,
    ...(lastRun.outcomeOrder !== undefined ? {
      outcome_order: lastRun.outcomeOrder
    } : {}),
    ...(lastRun.warning !== undefined ? {
      warning: lastRun.warning
    } : {}),
    ...(lastRun.outcomeMsg !== undefined ? {
      outcome_msg: lastRun.outcomeMsg
    } : {}),
    alerts_count: lastRun.alertsCount
  };
};
exports.transformRuleLastRun = transformRuleLastRun;
const transformMonitoring = monitoring => {
  return {
    run: {
      history: monitoring.run.history.map(history => ({
        success: history.success,
        timestamp: history.timestamp,
        ...(history.duration !== undefined ? {
          duration: history.duration
        } : {}),
        ...(history.outcome !== undefined ? {
          outcome: history.outcome
        } : {})
      })),
      calculated_metrics: monitoring.run.calculated_metrics,
      last_run: monitoring.run.last_run
    }
  };
};
exports.transformMonitoring = transformMonitoring;
const transformRuleActions = (actions = [], systemActions = []) => {
  return [...actions.map(action => {
    const {
      group,
      id,
      actionTypeId,
      params,
      frequency,
      uuid,
      alertsFilter,
      useAlertDataForTemplate
    } = action;
    return {
      group,
      id,
      params,
      connector_type_id: actionTypeId,
      ...(frequency ? {
        frequency: {
          summary: frequency.summary,
          notify_when: frequency.notifyWhen,
          throttle: frequency.throttle
        }
      } : {}),
      ...(uuid && {
        uuid
      }),
      ...(alertsFilter && {
        alerts_filter: alertsFilter
      }),
      ...(useAlertDataForTemplate !== undefined && {
        use_alert_data_for_template: useAlertDataForTemplate
      })
    };
  }), ...systemActions.map(sActions => {
    const {
      id,
      actionTypeId,
      params,
      uuid
    } = sActions;
    return {
      id,
      params,
      uuid,
      connector_type_id: actionTypeId
    };
  })];
};
exports.transformRuleActions = transformRuleActions;
const transformFlapping = flapping => {
  if (!flapping) {
    return flapping;
  }
  return {
    look_back_window: flapping.lookBackWindow,
    status_change_threshold: flapping.statusChangeThreshold
  };
};
exports.transformFlapping = transformFlapping;
const transformRuleToRuleResponse = rule => {
  var _rule$systemActions, _rule$executionStatus, _rule$isSnoozedUntil, _rule$nextRun;
  return {
    id: rule.id,
    enabled: rule.enabled,
    name: rule.name,
    tags: rule.tags,
    rule_type_id: rule.alertTypeId,
    consumer: rule.consumer,
    schedule: rule.schedule,
    actions: transformRuleActions(rule.actions, (_rule$systemActions = rule.systemActions) !== null && _rule$systemActions !== void 0 ? _rule$systemActions : []),
    params: rule.params,
    ...(rule.mapped_params ? {
      mapped_params: rule.mapped_params
    } : {}),
    ...(rule.scheduledTaskId !== undefined ? {
      scheduled_task_id: rule.scheduledTaskId
    } : {}),
    created_by: rule.createdBy,
    updated_by: rule.updatedBy,
    created_at: rule.createdAt.toISOString(),
    updated_at: rule.updatedAt.toISOString(),
    api_key_owner: rule.apiKeyOwner,
    ...(rule.apiKeyCreatedByUser !== undefined ? {
      api_key_created_by_user: rule.apiKeyCreatedByUser
    } : {}),
    ...(rule.throttle !== undefined ? {
      throttle: rule.throttle
    } : {}),
    mute_all: rule.muteAll,
    ...(rule.notifyWhen !== undefined ? {
      notify_when: rule.notifyWhen
    } : {}),
    muted_alert_ids: rule.mutedInstanceIds,
    ...(rule.scheduledTaskId !== undefined ? {
      scheduled_task_id: rule.scheduledTaskId
    } : {}),
    ...(rule.executionStatus ? {
      execution_status: {
        status: rule.executionStatus.status,
        ...(rule.executionStatus.error ? {
          error: rule.executionStatus.error
        } : {}),
        ...(rule.executionStatus.warning ? {
          warning: rule.executionStatus.warning
        } : {}),
        last_execution_date: (_rule$executionStatus = rule.executionStatus.lastExecutionDate) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.toISOString(),
        ...(rule.executionStatus.lastDuration !== undefined ? {
          last_duration: rule.executionStatus.lastDuration
        } : {})
      }
    } : {}),
    ...(rule.monitoring ? {
      monitoring: transformMonitoring(rule.monitoring)
    } : {}),
    ...(rule.snoozeSchedule ? {
      snooze_schedule: rule.snoozeSchedule
    } : {}),
    ...(rule.activeSnoozes ? {
      active_snoozes: rule.activeSnoozes
    } : {}),
    ...(rule.isSnoozedUntil !== undefined ? {
      is_snoozed_until: ((_rule$isSnoozedUntil = rule.isSnoozedUntil) === null || _rule$isSnoozedUntil === void 0 ? void 0 : _rule$isSnoozedUntil.toISOString()) || null
    } : {}),
    ...(rule.lastRun !== undefined ? {
      last_run: rule.lastRun ? transformRuleLastRun(rule.lastRun) : null
    } : {}),
    ...(rule.nextRun !== undefined ? {
      next_run: ((_rule$nextRun = rule.nextRun) === null || _rule$nextRun === void 0 ? void 0 : _rule$nextRun.toISOString()) || null
    } : {}),
    revision: rule.revision,
    ...(rule.running !== undefined ? {
      running: rule.running
    } : {}),
    ...(rule.viewInAppRelativeUrl !== undefined ? {
      view_in_app_relative_url: rule.viewInAppRelativeUrl
    } : {}),
    ...(rule.alertDelay !== undefined ? {
      alert_delay: rule.alertDelay
    } : {}),
    ...(rule.flapping !== undefined ? {
      flapping: transformFlapping(rule.flapping)
    } : {})
  };
};
exports.transformRuleToRuleResponse = transformRuleToRuleResponse;