"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.muteAllRuleRoute = void 0;
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _types = require("../../../../types");
var _track_deprecated_route_usage = require("../../../../lib/track_deprecated_route_usage");
var _mute_all = require("../../../../../common/routes/rule/apis/mute_all");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const muteAllRuleRoute = (router, licenseState, usageCounter) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}/_mute_all`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'public',
      summary: `Mute all alerts`,
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {
        params: _mute_all.muteAllRuleRequestParamsSchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given ID does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = req.params;
    (0, _track_deprecated_route_usage.trackDeprecatedRouteUsage)('muteAll', usageCounter);
    try {
      await rulesClient.muteAll(params);
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.muteAllRuleRoute = muteAllRuleRoute;