"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _license_api_access = require("../../lib/license_api_access");
var _common = require("../../../common");
var _track_legacy_route_usage = require("../../lib/track_legacy_route_usage");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const getAlertRoute = (router, licenseState, docLinks, usageCounter, isServerless) => {
  router.get({
    path: `${_common.LEGACY_BASE_ALERT_API_PATH}/alert/{id}`,
    validate: {
      params: paramSchema
    },
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: isServerless ? 'internal' : 'public',
      summary: 'Get an alert',
      tags: ['oas-tag:alerting'],
      deprecated: {
        documentationUrl: docLinks.links.alerting.legacyRuleApiDeprecations,
        severity: 'warning',
        reason: {
          type: 'migrate',
          newApiMethod: 'GET',
          newApiPath: '/api/alerting/rule/{id}'
        }
      }
    }
  }, router.handleLegacyErrors(async function (context, req, res) {
    (0, _license_api_access.verifyApiAccess)(licenseState);
    if (!context.alerting) {
      return res.badRequest({
        body: 'RouteHandlerContext is not registered for alerting'
      });
    }
    (0, _track_legacy_route_usage.trackLegacyRouteUsage)('get', usageCounter);
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const {
      id
    } = req.params;
    const {
      systemActions,
      ...rule
    } = await rulesClient.get({
      id,
      excludeFromPublicApi: true
    });
    return res.ok({
      body: rule
    });
  }));
};
exports.getAlertRoute = getAlertRoute;