"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findGapsRoute = void 0;
var _find = require("../../../../../common/routes/gaps/apis/find");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findGapsRoute = (router, licenseState) => {
  router.post({
    path: _types.INTERNAL_ALERTING_GAPS_FIND_API_PATH,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {
      body: _find.findGapsBodySchemaV1
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const query = req.body;
    const result = await rulesClient.findGaps((0, _transforms.transformRequestV1)(query));
    const response = {
      body: (0, _transforms.transformResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.findGapsRoute = findGapsRoute;