"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasRequiredPrivilegeGrantedInAllSpaces = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasRequiredPrivilegeGrantedInAllSpaces = async ({
  requiredPrivilege,
  spaceIds,
  request: req,
  authz
}) => {
  var _result$hasAllRequest;
  const result = await (authz === null || authz === void 0 ? void 0 : authz.checkPrivilegesWithRequest(req).atSpaces(spaceIds, {
    kibana: [authz.actions.api.get(`${requiredPrivilege}`)]
  }));
  return (_result$hasAllRequest = result === null || result === void 0 ? void 0 : result.hasAllRequested) !== null && _result$hasAllRequest !== void 0 ? _result$hasAllRequest : false;
};
exports.hasRequiredPrivilegeGrantedInAllSpaces = hasRequiredPrivilegeGrantedInAllSpaces;