"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsRequestTimeout = getEsRequestTimeout;
var _common = require("../../common");
var _get_rule_task_timeout = require("./get_rule_task_timeout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEsRequestTimeout(logger, timeout) {
  if (!timeout) {
    return undefined;
  }
  try {
    const maxRequestTimeout = (0, _common.parseDuration)(_get_rule_task_timeout.DEFAULT_EXECUTION_TIMEOUT);
    const requestTimeout = (0, _common.parseDuration)(timeout);
    // return the ES request timeout in ms that is capped at the default execution timeout (5 min).
    return requestTimeout > maxRequestTimeout ? maxRequestTimeout : requestTimeout;
  } catch (error) {
    logger.debug(`Invalid format for the rule ES requestTimeout duration: "${timeout}"`);
    return undefined;
  }
}